-- FUNCTION: public.ufd_est_prod_tbl_comis(integer, integer, integer, integer)

-- DROP FUNCTION IF EXISTS public.ufd_est_prod_tbl_comis(integer, integer, integer, integer);

CREATE OR REPLACE FUNCTION public.ufd_est_prod_tbl_comis(
	integer,
	integer,
	integer,
	integer)
    RETURNS double precision
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE PARALLEL UNSAFE
AS $BODY$


--<<inicio do corpo da funcao
-- function: select * from ufd_est_prod_tbl_comis(1, 18, 13492, 10)
--declara as variaveis usadas na funcao
declare
---------------------------------------------------------
----declara as variaveis que estao no cabecalho da funcao
---------------------------------------------------------
int_cd_emp              alias for $1;
int_cd_filial           alias for $2; 
int_cd_prod             alias for $3;
int_cd_vend             alias for $4;

retorno					double precision;
---------------------------------------------------------
---fim
---------------------------------------------------------
begin --inicio dos blocos da funcao
	-------------------------------------------------------------------------------------------------------------------------------
	--declarando tabela temporaria de retorno
	-------------------------------------------------------------------------------------------------------------------------------
	begin
		create temporary table temp_rs_tab_comis
		(	
			cd_tbl_comis 		integer,
			perc_comis 			double precision);
			
		exception when others then
		truncate table temp_rs_tab_comis; -- trunca a tabela se ela ja existir na corrente sessao.
	end;
	-------------------------------------------------------------------------------------------------------------------------------
	--declarando tabela que recebera as tbls vigentes
	-------------------------------------------------------------------------------------------------------------------------------
	
	-------------------------------------------------------------------------------------------------------------------------------
	--declarando tabela de arvore mercadologica do produto
	-------------------------------------------------------------------------------------------------------------------------------
	begin
		create temporary table rs_est_prod_arv_merc
		(
			cd_emp					integer,
			cd_prod					integer,
			cd_arv_merc_categ		integer,
			cd_arv_merc_linha		integer,
			cd_mc					integer,
			cd_arv_merc_familia		integer,								
			cd_fabric				integer
		);--fim rs_est_prod_arv_merc
		exception when others then
			truncate table rs_est_prod_arv_merc; -- trunca a tabela se ela ja existir na corrente sessao.
	end;
	-------------------------------------------------------------------------------------------------------------------------------	
	---------------------------------------------------fim da criacao das tbls temporarias-----------------------------------------
	-------------------------------------------------------------------------------------------------------------------------------
	-------------------------------------------------------------------------------------------------------------------------------
	--buscando arvore merc. do produto
	-------------------------------------------------------------------------------------------------------------------------------	
	insert into rs_est_prod_arv_merc		
		select 
			arv.cd_emp					,
			arv.cd_prod					,
			arv.cd_arv_merc_categ		,
			arv.cd_arv_merc_linha		,
			arv.cd_mc					,
			arv.cd_arv_merc_familia		,												
			p.cd_fabric					
		from 	
			est_prod_est_arv_mercadologica arv
			inner join est_prod p on
				arv.cd_emp		= p.cd_emp
				and arv.cd_prod = p.cd_prod
		where
			arv.cd_emp = int_cd_emp
			and	arv.cd_prod = int_cd_prod;
	if exists (select 1 from rs_est_prod_arv_merc) then
		-------------------------------------------------------------------    
		--tabelas de desc. quantidade    
		-------------------------------------------------------------------      
	 	insert into 
			temp_rs_tab_comis     
		select    
			a.cd_tbl_comis as cd_tbl_comis,    
			coalesce(b.perc_comis,0) as perc_comis
		from
			est_prod_tbl_comis a    
			inner join est_prod_tbl_comis_est_prod b on    
				a.cd_emp = b.cd_emp and    
				a.cd_tbl_comis = b.cd_tbl_comis    
			inner join est_prod_tbl_comis_prc_filial fil on    
				b.cd_emp = fil.cd_emp and
				b.cd_tbl_comis = fil.cd_tbl_comis
			inner join rs_est_prod_arv_merc arv on
				b.cd_emp = arv.cd_emp and    
				b.cd_prod = arv.cd_prod         
		where   
			a.cd_emp = int_cd_emp
			and fil.cd_filial = int_cd_filial
			and arv.cd_prod = int_cd_prod
			and not exists (
				select
					*
				from
					temp_rs_tab_comis
				where
					cd_tbl_comis = a.cd_tbl_comis);
			-------------------------------------------------------------------------------------------------------------------------------    
			--consultando as tbls de desconto para verificar se ha algum desconto no nivel 2 - familias    
			-------------------------------------------------------------------------------------------------------------------------------    
		insert into 
			temp_rs_tab_comis     
		select   
			a.cd_tbl_comis as cd_tbl_comis,    
			coalesce(b.perc_comis,0) as perc_comis
		from 
			est_prod_tbl_comis a    
			inner join est_prod_tbl_comis_est_arv_merc_familia b on    
				a.cd_emp = b.cd_emp and    
				a.cd_tbl_comis = b.cd_tbl_comis    
			inner join est_prod_tbl_comis_prc_filial fil on    
				b.cd_emp = fil.cd_emp and    
				b.cd_tbl_comis = fil.cd_tbl_comis
			inner join rs_est_prod_arv_merc arv on    
				b.cd_emp = arv.cd_emp and    
				b.cd_arv_merc_familia = arv.cd_arv_merc_familia        
		where     
			a.cd_emp = int_cd_emp
			and fil.cd_filial = int_cd_filial
			and arv.cd_prod = int_cd_prod
			and not exists (
				select
					*
				from
					temp_rs_tab_comis
				where
					cd_tbl_comis = a.cd_tbl_comis);
			-------------------------------------------------------------------------------------------------------------------------------        
			--consultando as tbls de desconto para verificar se ha algum desconto no nivel 3 - marcas    
			-------------------------------------------------------------------------------------------------------------------------------    
		insert into 
			temp_rs_tab_comis     
		select
			a.cd_tbl_comis as cd_tbl_comis,    
			coalesce(b.perc_comis,0) as perc_comis
		from 
			est_prod_tbl_comis a    
			inner join est_prod_tbl_comis_est_mc b on    
				a.cd_emp = b.cd_emp and    
				a.cd_tbl_comis = b.cd_tbl_comis    
			inner join est_prod_tbl_comis_prc_filial fil on    
				b.cd_emp = fil.cd_emp and    
				b.cd_tbl_comis = fil.cd_tbl_comis    
			inner join rs_est_prod_arv_merc arv on    
				b.cd_emp = arv.cd_emp and    
				b.cd_mc = arv.cd_mc        
		where     
			a.cd_emp = int_cd_emp
			and fil.cd_filial = int_cd_filial
			and arv.cd_prod = int_cd_prod
			and not exists (
				select
					*
				from
					temp_rs_tab_comis
				where
					cd_tbl_comis = a.cd_tbl_comis);
			-------------------------------------------------------------------------------------------------------------------------------    
			--consultando as tbls de desconto para verificar se ha algum desconto no nivel 4 - fabricantes    
			-------------------------------------------------------------------------------------------------------------------------------    
		insert into 
			temp_rs_tab_comis     
		select   
			a.cd_tbl_comis as cd_tbl_comis,    
			coalesce(b.perc_comis,0) as perc_comis
		from 
			est_prod_tbl_comis a    
			inner join est_prod_tbl_comis_est_prod_fabric b on    
				a.cd_emp = b.cd_emp and    
				a.cd_tbl_comis = b.cd_tbl_comis    
			inner join est_prod_tbl_comis_prc_filial fil on    
				b.cd_emp = fil.cd_emp and    
				b.cd_tbl_comis = fil.cd_tbl_comis    
			inner join rs_est_prod_arv_merc arv on    
				b.cd_emp = arv.cd_emp and    
				b.cd_fabric = arv.cd_fabric
		where     
			a.cd_emp = int_cd_emp
			and fil.cd_filial = int_cd_filial
			and arv.cd_prod = int_cd_prod
			and not exists (
				select
					*
				from
					temp_rs_tab_comis
				where
					cd_tbl_comis = a.cd_tbl_comis);
			------------------------------------------------------------------------------------------------------------------------------    
			--consultando as tbls de desconto para verificar se ha algum desconto no nivel 5 - categorias         
			-------------------------------------------------------------------------------------------------------------------------------    
		insert into 
			temp_rs_tab_comis     
		select   
			a.cd_tbl_comis as cd_tbl_comis,    
			coalesce(b.perc_comis,0) as perc_comis
		from 
			est_prod_tbl_comis a    
			inner join est_prod_tbl_comis_est_arv_merc_categoria b on    
				a.cd_emp = b.cd_emp and    
				a.cd_tbl_comis = b.cd_tbl_comis    
			inner join est_prod_tbl_comis_prc_filial fil on
				b.cd_emp = fil.cd_emp and    
				b.cd_tbl_comis = fil.cd_tbl_comis    
			inner join rs_est_prod_arv_merc arv on    
				b.cd_emp = arv.cd_emp and    
				b.cd_arv_merc_categ = arv.cd_arv_merc_categ        
		where     
			a.cd_emp = int_cd_emp
			and fil.cd_filial = int_cd_filial
			and arv.cd_prod = int_cd_prod
			and not exists (
			select
				*
			from
				temp_rs_tab_comis
			where
				cd_tbl_comis = a.cd_tbl_comis);
			-------------------------------------------------------------------------------------------------------------------------------    
			--consultando as tbls de desconto para verificar se ha algum desconto no nivel 6 - linhas
			-------------------------------------------------------------------------------------------------------------------------------    
		insert into 
			temp_rs_tab_comis     
		select   
			a.cd_tbl_comis as cd_tbl_comis,    
			coalesce(b.perc_comis,0) as perc_comis
		from 
			est_prod_tbl_comis a    
			inner join est_prod_tbl_comis_est_arv_merc_linha b on    
				a.cd_emp = b.cd_emp and    
				a.cd_tbl_comis = b.cd_tbl_comis    
			inner join est_prod_tbl_comis_prc_filial fil on    
				b.cd_emp = fil.cd_emp and    
				b.cd_tbl_comis = fil.cd_tbl_comis    
			inner join rs_est_prod_arv_merc arv on    
				b.cd_emp = arv.cd_emp and       
				b.cd_arv_merc_linha = arv.cd_arv_merc_linha    
		where     
			a.cd_emp = int_cd_emp
			and fil.cd_filial = int_cd_filial
			and arv.cd_prod = int_cd_prod
			and not exists (
			select
				*
			from
				temp_rs_tab_comis
			where
				cd_tbl_comis = a.cd_tbl_comis);
	end if;
	-------------------------------------------------------------------------------------------------------------------------------
	-- retornando desconto limite (resultado da funcao)
	-------------------------------------------------------------------------------------------------------------------------------
	SELECT 
		max(coalesce(a.perc_comis,0)) as perc_comis
	INTO 
		retorno
	from
		temp_rs_tab_comis a
		inner join fp_cargo_est_prod_tbl_comis b on
			a.cd_tbl_comis = b.cd_tbl_comis
		inner join fp_func c on
			b.cd_cargo = c.cd_cargo
	where
		c.cd_fun = int_cd_vend;
  	return coalesce(retorno, 0);
end; --fim dos blocos da função
$BODY$;

ALTER FUNCTION public.ufd_est_prod_tbl_comis(integer, integer, integer, integer)
    OWNER TO postgres;
